%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%DECLARATION OF ENDOGENOUS VARIABLES%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
var 
    V Vmodified U C H K S X I IS Sdash lambda Wh rK RPS R Q Rn PIE PIEw W Jw Hd MRSS JJw WO Deltaw YW A PWP MC Jp Y MCS JJp PO Deltap MPS G RK spread CEquiv
    dyobs dcobs pinfobs robs labobs spreadobs dinvobs dwobs UH; // observables
 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%DECLARATION OF EXOGENOUS VARIABLES%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
varexo epsA epsG epsMCS epsMPS epsIS epsMRSS epsRPS;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%DECLARATION OF PARAMETERS%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
parameters gy alp delta zzetap zzetaw              // calibrated/fixed parameters
           sigma_c chi phiX xip xiw gammap gammaw PIE_bar g_bar Rn_bar // estimated parameters: structural parameters
           rho_r theta_pie theta_y theta_dy                                // estimated parameters: Taylor rule
           rhoA rhoG rhoMCS rhoMRSS rhoMPS rhoRPS rhoIS                    // estimated parameters: shock processes
           sigma_s wr psi;                                               // misc parameters

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%CALIBRATED/FIXED OF PARAMETERS%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  gy           = 0.18;
  alp          = 0.67;
  delta        = 0.0250;
  zzetap       = 7.0;
  zzetaw       = 3.0;
  PIE_bar      = 100*0.008662984461054;
  g_bar        = 100*0.003550693291143;
  Rn_bar       = 100*0.013318469551282;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%ESTIMATED STRUCTURAL PARAMETERS%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  sigma_c      = 1.5;
  chi          = 0.7;
  phiX         = 2.0;
  xip          = 0.7;
  xiw          = 0.7;
  gammap       = 0.5;
  gammaw       = 0.5;
  psi          = 2;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%ESTIMATED POLICY PARAMETERS%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  rho_r        = 0.7;
  theta_pie    = 1.5;
  theta_y      = 0.3;
  theta_dy     = 0.3;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%ESTIMATED SHOCK PROCESS PARAMETERS%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  rhoA         = 0.7;
  rhoG         = 0.7;
  rhoMCS       = 0.7;
  rhoMRSS      = 0.7;
  rhoMPS       = 0.7;
  rhoRPS       = 0.7;
  rhoIS        = 0.7;

%%%%%%%%%%%%%%%%%%%
%%MISC PARAMETERS%%
%%%%%%%%%%%%%%%%%%%

  sigma_s      = 0.01;
  wr           = 0.0;

% ----------------------------
% *** DSGE-Model-equations ***
% ----------------------------

model;
// name = '(273) Calibration of beta)'
  # g                               = g_bar/100;
  # betta                           = (PIE_bar/100+1)/(Rn_bar/100+1)/(1+g)^(-sigma_c);

% -----------------
% *** Household ***
% -----------------

[ name = '(226) Consumption equivalent variation']
  CEquiv                            = (1.01^(1-sigma_c)-1)*U + betta*(1+g)^(1-sigma_c)*CEquiv(+1);

[ name = '(185) Intertemporal welfare']
  V                                 = U+betta*(1+g)^(1-sigma_c)*V(+1);

[ name = '(185b) Modified intertemporal welfare']
  Vmodified                         = U-wr*(Rn-STEADY_STATE(Rn))^2+betta*(1+g)^(1-sigma_c)*Vmodified(+1);

[ name = '(186) Flow utility']
  U                                 = ((C-chi*C(-1)/(1+g))^(1-sigma_c))/(1-sigma_c)*exp((sigma_c-1)*H^(1+psi)/(1+psi));

[ name = '(187) Law of motion for capital']
  K                                 = (1-delta)*K(-1)/(1+g)+(1-S)*I*IS;

[ name = '(188) Investment']
  X                                 = I*(1+g)/I(-1);

[ name = '(189) Capital adjustment cost']
  S                                 = phiX*(X-1-g)^2;

[ name = '(190) Capital adjustment cost']
  Sdash                             = 2*phiX*(X-1-g);

[ name = '(191) MUC']
  lambda                            = (1-sigma_c)*U/(C-chi*C(-1)/(1+g))-betta*chi*(1-sigma_c)*U(+1)/(1+g)^(1-sigma_c)/((1+g)*C(+1)-chi*C);

[ name = '(192) Household foc for hours']
//  Wh                                = (C-chi*C(-1)/(1+g))*H^psi/(1-betta*chi*(1+g)^(1-sigma_c)*U(+1)/U*(C-chi*C(-1)/(1+g))/((1+g)*C(+1)-chi*C));
  Wh                                = -UH/lambda;

// name = '(196) Stochastic discount factor']
  # LAMBDA_LEAD                       = betta*(1+g)^(-sigma_c)*lambda(+1)/lambda;

[ name = '(193) Euler equation']
  1                                 = RPS*R(+1)*LAMBDA_LEAD;

[ name = '(194) Household foc for capital']
  Q                                 = LAMBDA_LEAD*(rK(+1)+(1-delta)*Q(+1));

[ name = '(195) Household foc for investment']
  1                                 = Q*(1-S-Sdash*X)*IS
                                    + LAMBDA_LEAD*Q(+1)*Sdash(+1)*X(+1)^2*IS(+1);

[ name = '(197) Fischer equation']
  R                                 = Rn(-1)/PIE;

  UH                                = -(1-sigma_c)*U*H^psi;

% --------------------
% *** Wage setting ***
% --------------------

[ name = '(198) Wage inflation']
  PIEw                              = (1+g)*W/W(-1)*PIE;

[ name = '(199) Wage setting condition I']
  Jw                                = (1/(1-1/zzetaw))*Wh*Hd*MRSS
                                    + xiw*(1+g)*LAMBDA_LEAD*(PIEw(+1)^zzetaw/PIE^(gammaw*zzetaw))*Jw(+1);

[ name = '(200) Wage setting condition II']
  JJw                               = Hd + xiw*LAMBDA_LEAD*(PIEw(+1)^zzetaw/(PIE^(gammaw*(zzetaw-1))*PIE(+1)))*JJw(+1);

[ name = '(201) Wage setting condition III']
  WO                                = Jw/(W*JJw);

[ name = '(202) Law of motion for wage level']
  1                                 = xiw*(PIE(-1)^gammaw/PIEw)^(1-zzetaw)+(1-xiw)*WO^(1-zzetaw);

[ name = '(203) Law of motion for wage dispersion']
  Deltaw                            = xiw*(PIEw^zzetaw/PIE(-1)^(zzetaw*gammaw))*Deltaw(-1)+(1-xiw)*WO^(-zzetaw);

% -------------------
% *** Retail firm ***
% -------------------

[ name = '(204) Production function']
  YW                                = (A*Hd)^alp*(K(-1)/(1+g))^(1-alp);

[ name = '(205) Firm for for labour']
  W                                 = alp*PWP*YW/Hd;

[ name = '(206) Firm foc: return on capital']
  rK                                = (1-alp)*PWP*YW/(K(-1)/(1+g));

% ---------------------
% *** Price setting ***
% ---------------------

[ name = '(207) Marginal cost']
  MC                                = PWP;

[ name = '(208) Price setting condition']
  Jp                                = (1/(1-1/zzetap))*Y*MC*MCS
                                      +xip*(1+g)*LAMBDA_LEAD*(PIE(+1)^zzetap/PIE^(gammap*zzetap))*Jp(+1);

[ name = '(209) Price setting condition']
  JJp                               = Y+xip*(1+g)*LAMBDA_LEAD*(PIE(+1)^(zzetap-1)/PIE^(gammap*(zzetap-1)))*JJp(+1);

[ name = '(210) Price setting condition']
  PO                                = Jp/JJp;

[ name = '(211) Law of motion for price level']
  1                                 = xip*(PIE(-1)^(gammap)/PIE)^(1-zzetap)+(1-xip)*(PO)^(1-zzetap);

[ name = '(212) Law of motion for price dispersion']
  Deltap                            = xip*(PIE^zzetap/PIE(-1)^(zzetap*gammap))*Deltap(-1)+(1-xip)*PO^(-zzetap);

% -----------------------
% *** Monetary policy ***
% -----------------------

[ name = '(213) Taylor rule']
  log(Rn/STEADY_STATE(Rn))          = rho_r*log(Rn(-1)/STEADY_STATE(Rn))
                                    +(1-rho_r)*(theta_pie*log(PIE/STEADY_STATE(PIE))+theta_y*log(Y/STEADY_STATE(Y))+theta_dy*log(Y/Y(-1)))
                                    +log(MPS);

[ name = '(214) Resource constraint']
  Y                                 = C+G+I;

[ name = '(215) Market clearing for labour)']
  H                                 = Deltaw*Hd;

[ name = '(216) Market clearing for goods']
  YW                                = Y*Deltap;

[ name = '(217) Gross real return on capital']
  RK                                = (rK+(1-delta)*Q)/Q(-1);

[ name = '(218)']
  spread                            = RK-R;

% -----------------------
% *** Shock processes ***
% -----------------------

[ name = '(219) Law of motion for productivity']
  log(A)-log(STEADY_STATE(A))       = rhoA*(log(A(-1))-log(STEADY_STATE(A)))+epsA;

[ name = '(220) Law of motion for government expenditure']
  log(G)-log(STEADY_STATE(G))       = rhoG*(log(G(-1))-log(STEADY_STATE(G)))+epsG;

[ name = '(221) Law of motion for price markup shock']
  log(MCS)-log(STEADY_STATE(MCS))   = rhoMCS*(log(MCS(-1))-log(STEADY_STATE(MCS)))+epsMCS;

[ name = '(232) Law of motion for wage markup shock']
  log(MRSS)-log(STEADY_STATE(MRSS)) = rhoMRSS*(log(MRSS(-1))-log(STEADY_STATE(MRSS)))+epsMRSS;

[ name = '(233) Law of motion for capital quality shock']
  log(IS)-log(STEADY_STATE(IS))     = rhoIS*(log(IS(-1))-log(STEADY_STATE(IS)))+epsIS;

[ name = '(234) Law of motion for monetary policy shock']
  log(MPS)-log(STEADY_STATE(MPS))   = rhoMPS*(log(MPS(-1))-log(STEADY_STATE(MPS)))+epsMPS;

[ name = '(235) Law of motion for risk premium shock']
  log(RPS)-log(STEADY_STATE(RPS))   = rhoRPS*(log(RPS(-1))-log(STEADY_STATE(RPS)))+epsRPS;

% -----------------------------
% *** Measurement equations ***
% -----------------------------

[ name = '(264) Measurement equation for output growth']
  dyobs                             = log(Y/Y(-1)*(1+g));

[ name = '(265) Measurement equation for consumption growth']
  dcobs                             = log(C/C(-1)*(1+g));

[ name = '(266) Measurement equation for investment growth']
  dinvobs                           = log(I/I(-1)*(1+g));

[ name = '(267) Measurement equation for real wage growth']
  dwobs                             = log(W/W(-1)*(1+g));

[ name = '(268) Measurement equation for hours']
  labobs                            = (Hd-STEADY_STATE(Hd))/STEADY_STATE(Hd);

[ name = '(269) Measurement equation for policy rate']
  robs                              = Rn-1;

[ name = '(270) Measurement equation for inflation']
  pinfobs                           = log(PIE);

[ name = '(271) Measurement equation for spread']
  spreadobs                         = spread;
end;

shocks;
  var epsA;    stderr sigma_s;
  var epsG;    stderr sigma_s;
  var epsMCS;  stderr sigma_s;
  var epsMPS;  stderr sigma_s;
  var epsMRSS; stderr sigma_s;
  var epsRPS;  stderr sigma_s;
  var epsIS;   stderr sigma_s;
end;

check;
steady;

estimated_params;
       sigma_c,                      NORMAL_PDF,     1.50, 0.375;
       psi,                          NORMAL_PDF,     2.00, 0.75;
       chi,                          BETA_PDF,       0.50, 0.10;
       phiX,                         NORMAL_PDF,     2.00, 0.75; 
       xip,                          BETA_PDF,       0.50, 0.10;
       xiw,                          BETA_PDF,       0.50, 0.10;
       gammap,                       BETA_PDF,       0.50, 0.10;
       gammaw,                       BETA_PDF,       0.50, 0.10;

       PIE_bar,                      NORMAL_PDF,     1.0,0.50; //quarterly ss inflation rate;
       g_bar,                        NORMAL_PDF,     0.4,0.50; //common quarterly trend growth rate
       Rn_bar,                       NORMAL_PDF,     1.6,0.50;   //common quarterly nominal interest rate

       rho_r,                        BETA_PDF,       0.75, 0.10;
       theta_pie,                    NORMAL_PDF,     1.50, 0.25;
       theta_y,                      NORMAL_PDF,     0.12, 0.05;
       theta_dy,                     NORMAL_PDF,     0.12, 0.05;

       rhoA,                         BETA_PDF,       0.50, 0.20;
       rhoG,                         BETA_PDF,       0.50, 0.20;
       rhoMCS,                       BETA_PDF,       0.50, 0.20;
       rhoMRSS,                      BETA_PDF,       0.50, 0.20;
       rhoMPS,                       BETA_PDF,       0.50, 0.20;
       rhoRPS,                       BETA_PDF,       0.50, 0.20;
       rhoIS,                        BETA_PDF,       0.50, 0.20;

       stderr epsA,                  INV_GAMMA_PDF,  0.001, 0.020;
       stderr epsG,                  INV_GAMMA_PDF,  0.001, 0.020;
       stderr epsMCS,                INV_GAMMA_PDF,  0.001, 0.020;
       stderr epsMRSS,               INV_GAMMA_PDF,  0.001, 0.020;
       stderr epsMPS,                INV_GAMMA_PDF,  0.001, 0.020;
       stderr epsRPS,                INV_GAMMA_PDF,  0.001, 0.020; 
       stderr epsIS,                 INV_GAMMA_PDF,  0.001, 0.020;
end;

varobs dyobs dcobs dinvobs dwobs robs pinfobs labobs;
//varobs dyobs dcobs dinvobs spreadobs robs pinfobs labobs;
estimation(
datafile=usdata_47q1_17q4_unscaled,
first_obs=75,nobs=208,
mode_compute=4, //method of Chris Sims. Use 6 if 4 doesnt work. But this takes a long time to run
presample=0,
prefilter=0, //detrends the data. but out data is already deterended
plot_priors=0,
lik_init=1, // initialization of the MCMC
mh_replic=5000, // in practise this should be much larger
mh_nblocks=2, // at least 2 for comparison. Often 4 are used in practise
mh_jscale=0.4, // for acceptance rate
mh_drop=0.25, // first 25% of draws considered as burn-in
mode_check
);
//estimation(datafile=usdata_47q1_17q4_unscaled,first_obs=75,nobs=208,mode_compute=0,mode_file=NK_financial_mode,presample=0,prefilter=0,plot_priors=0,lik_init=1,mh_replic=50000,mh_nblocks=2,mh_jscale=0.4,mh_drop=0.25,  mode_check );
//identification(advanced=1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%generate IRfunctions and Moments of obs
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%get_posterior_parameters('mean',M_,estim_params_,oo_,options_) 
// get post. mean for steady state and simulation.
%or use mode:
%get_posterior_parameters('mode',M_,estim_params_,oo_,options_)
// get post. mean for steady state and simulation
stoch_simul(irf=20,ar=10, nograph);

